<?php

namespace App\Filament\Resources\EntryResource\Pages;

use App\Filament\Resources\EntryResource;
use App\Models\Entry;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Database\Eloquent\Model;

class CreateEntry extends CreateRecord
{
    protected static string $resource = EntryResource::class;
    protected function handleRecordCreation(array $data): Model
    {
        /** * @var Entry $record */
        $record = parent::handleRecordCreation($data);
        $record->syncTagsByTitle($data['tags']);
        return $record;
    }
}
